#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# -------------------------------------------------------------------------------------
#
# Copyright (c) 2013, Jose F. Maldonado
# All rights reserved.
#
# Redystrybucja i wykorzystanie w postaci źródłowej i binarnej, z modyfikacjami lub bez,
# Są dozwolone pod warunkiem, że spełnione są następujące warunki:
# 	- Redystrybucja kodu źródłowego musi zawierać powyższą informację o prawach autorskich, 
#      niniejszą listę warunków i poniższe zrzeczenie.
#   - Redystrybucji w postaci binarnej muszą zawierać powyższą informację o prawach autorskich, 
#		niniejszą listę warunków i poniższe zrzeczenie w dokumentacji i / lub innych 
#		materiałach dostarczonych wraz z dystrybucją.
#   - Nazwisko autora ani nazwy wspólników firmy nie mogą być używane do celów promowania 
#		produktów wyprowadzonych z niniejszego oprogramowania bez wcześniejszej wyraźnej, 
#		pisemnej zgody.

"""
BSD 3-clause license
Licencja typu BSD skupia się na prawach użytkownika. Jest bardzo liberalna, 
zezwala nie tylko na modyfikacje kodu i jego rozprowadzanie w takiej postaci, 
ale także na rozprowadzanie produktu bez postaci źródłowej czy wręcz włączenia 
do zamkniętego oprogramowania, pod warunkiem załączenia do produktu informacji 
o autorach oryginalnego kodu i treści licencji.
"""

from gimpfu import *

def open_to_layer(image, layer, file):
    ''' Save the current layer into a PNG file, a JPEG file and a BMP file.
    
    Parameters:
    image : image The current image.
    layer : layer The layer of the image that is selected.
    file : string The file to open in a new layer.
    '''
    # Wskazuje, że ten proces został zapoczątkowany.
    gimp.progress_init("Opening '" + file + "'...")
    
    try:
        # Otwórz jakikolwiek plik png, jpg, bmp, gif.
        fileImage = None
        if(file.lower().endswith(('.png'))):
            fileImage = pdb.file_png_load(file, file)
        if(file.lower().endswith(('.jpeg', '.jpg'))):
            fileImage = pdb.file_jpeg_load(file, file)
        if(file.lower().endswith(('.bmp'))):
            fileImage = pdb.file_bmp_load(file, file)
        if(file.lower().endswith(('.gif'))):
            fileImage = pdb.file_gif_load(file, file)
        # Jeśli nie otworzymy pliku obrazu, poniższy Komunikat zostanie wyświetlany w otwartej Konsoli błęd
        if(fileImage is None):
            gimp.message("Obraz nie mógł zostać otwarty, ponieważ brak jest pliku obrazu.")
        else :
            # Utwórz nową warstwę.
            newLayer = gimp.Layer(image, "new layer", layer.width, layer.height, layer.type, layer.opacity, layer.mode)
            image.add_layer(newLayer, 0)               
        
            # Umieścić obraz na nowej warstwie.
            fileLayer = fileImage.layers[0]
            pdb.gimp_edit_copy(fileLayer)
            pdb.gimp_edit_paste(newLayer, True)
        
            # Aktualizuj nową warstwę.
            newLayer.flush()
            newLayer.merge_shadow(True)
            newLayer.update(0, 0, newLayer.width, newLayer.height)
        
    except Exception as err:
        gimp.message("Unexpected error: " + str(err))
    
register(
    "test_open_to_layer",
    "Otwórz plik jako nową warstwę",
    "Otwiera jakiś obraz jako nową warstwę.",
    "JFM Modified Zbyma72age",
    "Open source (BSD 3-clause license)",
    "2013 Modified 2015",
    "<Image>/TEST/Testowanie/Otwórz plik w nowej warstwie",
    "*",
    [
        (PF_FILE, "file", "Otwórz plik", ""),
    ],
    [],
    open_to_layer
	)

main()
